define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('localResourceDirectoryService', function ($http, $q) {
		var directory = {},
			isReady;

		directory.fetch = function () {
			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();
			$http.get("resources.json")
				.then(function (responses) {
					var resources = responses.data;
					resources['link'].forEach(function (link){
						directory[link['title']] = link['href'];
					});
					isReady.resolve(directory);
				}, function (error) {
					isReady.reject(error);
					isReady = null;
				});

			return isReady.promise;

		};



		directory.updatePatientIdentifiers = function (user) {
			var patientId = user.id,
				assigningAuthority = user.idType,
				link;

			for (var prop in directory) {
				if (typeof directory[prop] === 'string') {
					var link = directory[prop];
					directory[prop] = link.replace("{ASSIGNING_AUTHORITY}", assigningAuthority).replace('{UNIQUE_ID}', patientId);

				}
			}
		};

		return directory;
	});
});